package com.elitescloud.cloudt.system.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.system.common.BasicRecordStateEnum;
import com.elitescloud.cloudt.system.service.common.constant.BasicRecordTypeEnum;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.time.LocalDateTime;

/**
 * 基础数据同步记录.
 *
 * @author Kaiser（wang shao）
 * @date 2023/11/27
 */
@Entity
@Table(name = "sys_basic_record", indexes = {
})
@Comment("基础数据同步记录")
@Getter
@Setter
public class SysBasicRecordDO extends BaseModel {
    private static final long serialVersionUID = 590014524873105515L;

    @Column
    @Comment(value = "记录类型")
    @Enumerated(value = EnumType.STRING)
    private BasicRecordTypeEnum recordType;

    @Column
    @Comment(value = "是否全量", defaultValue = "0")
    private Boolean allData;

    @Column
    @Comment(value = "全部版本", defaultValue = "0")
    private Boolean allVersion;

    @Column
    @Comment(value = "数据版本")
    private String dataVersion;

    @Column
    @Comment(value = "是否所有类型", defaultValue = "0")
    private Boolean allType;

    @Column
    @Comment(value = "数据类型")
    @Lob
    private String dataType;

    @Column
    @Comment(value = "租户编码")
    private String tenantCode;

    @Column
    @Comment(value = "导出应用")
    private String appCodes;

    @Column
    @Comment(value = "是否同步给租户", defaultValue = "0")
    private Boolean syncTenant;

    @Column
    @Comment(value = "说明")
    private String description;

    @Column
    @Comment(value = "数据文件")
    private String dataFileCode;

    @Column
    @Comment(value = "属性列表")
    @Lob
    private String attribute;

    @Column
    @Comment(value = "操作时间")
    private LocalDateTime operateTime;

    @Column
    @Comment(value = "是否成功", defaultValue = "0")
    private Boolean success;

    @Column
    @Comment(value = "是否结束", defaultValue = "0")
    private Boolean finished;

    @Column
    @Comment(value = "结束时间")
    private LocalDateTime finishTime;

    /**
     * 参考：{@link com.elitescloud.cloudt.system.common.BasicRecordStateEnum}
     */
    @Column
    @Comment(value = "状态")
    private String state;

    @Column
    @Comment(value = "备份文件")
    private String backupFileCode;

    @Column
    @Comment(value = "是否标产", defaultValue = "0")
    private Boolean std;

    @Column
    @Comment(value = "失败原因")
    @Lob
    private String failReason;
}
