package com.elitescloud.cloudt.system.model.vo.query.businessobject;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * 业务对象信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/13
 */
@Getter
@Setter
@ApiModel(description = "业务对象信息")
public class BusinessObjectPageQueryVO extends AbstractOrderQueryParam {
    private static final long serialVersionUID = 8555231278147215773L;

    @ApiModelProperty(value = "OpenApi编码")
    private String openApiCode;

    @ApiModelProperty(value = "应用编码")
    private String appCode;

    @ApiModelProperty(value = "业务对象的编码")
    private String code;

    @ApiModelProperty(value = "业务对象的名称")
    private String name;

    @ApiModelProperty(value = "业务对象的描述")
    private String description;

    @ApiModelProperty(value = "领域分类")
    private String domain;

    @ApiModelProperty(value = "是否启用")
    private Boolean enabled;
}
