package com.elitescloud.cloudt.system.model.vo.query.businessobject;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * 业务操作分页查询参数.
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/20
 */
@Getter
@Setter
@ApiModel(description = "业务操作分页查询参数")
public class BusinessOperationPageQueryVO extends AbstractOrderQueryParam {
    private static final long serialVersionUID = 4196131349092075936L;

    @ApiModelProperty(value = "业务对象ID")
    private Long businessObjectId;

    @ApiModelProperty(value = "操作编码")
    private String operationCode;

    @ApiModelProperty(value = "操作描述")
    private String operationDescription;

    @ApiModelProperty(value = "API的URL")
    private String apiUrl;

    @ApiModelProperty(value = "是否数据权限")
    private Boolean permissionEnabled;
}
