package com.elitescloud.cloudt.system.model.vo.resp.businessobject;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 业务对象参数.
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/20
 */
@Getter
@Setter
@ApiModel(description = "业务对象参数")
public class BusinessObjectParamRespVO implements Serializable {
    private static final long serialVersionUID = -3793133193487126116L;

    @ApiModelProperty(value = "ID", position = 1)
    private Long id;

    @ApiModelProperty(value = "字段名称", position = 2)
    private String fieldName;

    @ApiModelProperty(value = "字段描述", position = 3)
    private String fieldDescription;

    @ApiModelProperty(value = "java类型", position = 4)
    private String fieldJavaType;

    @ApiModelProperty(value = "关联的业务对象", position = 6)
    private String relatedBusinessObject;

    @ApiModelProperty(value = "关联的业务对象字段", position = 8)
    private String relatedField;

    @ApiModelProperty(value = "用于数据权限", position = 8)
    private Boolean dataPermissionEnabled;

    @ApiModelProperty(value = "用于字段权限", position = 9)
    private Boolean fieldPermissionEnabled;
}
