package com.elitescloud.cloudt.system.model.vo.resp.datarelation;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 数据关系实例编辑信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/15
 */
@Getter
@Setter
@ApiModel(description = "数据关系实例编辑信息")
public class DataRelationInstEditRespVO implements Serializable {
    private static final long serialVersionUID = -6922875877783385785L;

    @ApiModelProperty(value = "数据关系编码", position = 1, required = true)
    private String drCode;

    @ApiModelProperty(value = "主数据的标识", position = 2, required = true)
    private String dataKey;

    @ApiModelProperty(value = "分类数据列表", position = 3)
    private List<CatData> catList;

    @Getter
    @Setter
    @ApiModel(value = "DataRelationInstEditRespVO_CatData", description = "数据关系的分类返回的值")
    public static class CatData implements Serializable {
        private static final long serialVersionUID = 4757008415237192345L;

        @ApiModelProperty(value = "分类编码", position = 1)
        private String catCode;

        @ApiModelProperty(value = "主数据的属性", position = 2)
        private String dataAttribute;

        @ApiModelProperty(value = "主数据的扩展信息，键值对，可选", position = 3)
        private Map<String, String> dataExt;

        @ApiModelProperty(value = "数据值列表", position = 11)
        private List<InstData> dataList;
    }

    @Getter
    @Setter
    @ApiModel(value = "DataRelationInstEditRespVO_InstData", description = "数据关系的返回的值")
    public static class InstData implements Serializable {
        private static final long serialVersionUID = 4757008415237192345L;

        @ApiModelProperty(value = "关联数据的标识", position = 1)
        private String refDataKey;

        @ApiModelProperty(value = "关联数据的检索属性", position = 2)
        private String refDataAttribute;

        @ApiModelProperty(value = "关联数据的扩展信息，键值对", position = 11)
        private Map<String, String> refDataExt;
    }
}
