package com.elitescloud.cloudt.system.model.vo.resp.devops;

import com.elitescloud.boot.common.param.CodeNameParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 导出记录.
 *
 * @author Kaiser（wang shao）
 * @date 2024/1/18
 */
@Data
@ApiModel(description = "导出记录")
public class BasicRecordExportPageRespVO implements Serializable {
    private static final long serialVersionUID = -8806385381462987037L;

    @ApiModelProperty(value = "ID", position = 1)
    private Long id;

    @ApiModelProperty(value = "导出类型-是否全量", position = 2)
    private Boolean allVersion;

    @ApiModelProperty(value = "数据版本", position = 3)
    private String dataVersion;

    @ApiModelProperty(value = "数据类型-是否全部", position = 4)
    private Boolean allType;

    @ApiModelProperty(value = "数据类型", position = 5)
    private List<CodeNameParam> dataTypes;

    @ApiModelProperty(value = "导出时间", position = 6)
    private LocalDateTime operateTime;

    @ApiModelProperty(value = "导出说明", position = 7)
    private String description;

    @ApiModelProperty(value = "导出结果-是否成功", position = 9)
    private Boolean success;

    @ApiModelProperty(value = "导出结果-是否结束", position = 8)
    private Boolean finished;

    @ApiModelProperty(value = "导出文件的唯一标识", position = 10)
    private String dataFileCode;

    @ApiModelProperty(value = "失败原因", position = 11)
    private String failReason;
}
