package com.elitescloud.cloudt.system.model.vo.resp.dpr;

import com.elitescloud.boot.datasecurity.dpr.content.DprRuleConditionEnum;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleRelationEnum;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleValueTypeEnum;
import com.elitescloud.cloudt.system.model.vo.save.dpr.DataPermissionRuleSaveVO;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 数据权限字段.
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/16
 */
@ApiModel(description = "数据权限字段")
@Getter
@Setter
public class DataPermissionRuleRespVO implements Serializable {
    private static final long serialVersionUID = 905290874114633794L;

    @ApiModelProperty(value = "是否是规则组", position = 1)
    private Boolean ruleGroup;

    @ApiModelProperty(value = "组内规则关系", position = 2)
    private DprRuleRelationEnum groupRelation;

    @ApiModelProperty(value = "组内规则关系", position = 2)
    private String groupRelationName;

    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @ApiModelProperty(value = "规则组编码", position = 2, hidden = true)
    private String ruleGroupCode;

    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @ApiModelProperty(value = "上级规则组编码", position = 2, hidden = true)
    private String ruleGroupCodeParent;

    @ApiModelProperty(value = "组内规则列表", position = 3)
    private List<DataPermissionRuleRespVO> groupRules;

    @ApiModelProperty(value = "规则ID", position = 11)
    private Long id;

    @ApiModelProperty(value = "规则名称", position = 12)
    private String dprRuleName;

    @ApiModelProperty(value = "规则字段", position = 13)
    private String dprRuleField;

    @ApiModelProperty(value = "是否引用资源配置", position = 14)
    private Boolean refResource;

    @ApiModelProperty(value = "引用的业务对象编码", position = 15)
    private String refBusinessObject;
    @ApiModelProperty(value = "引用的业务对象名称", position = 15)
    private String refBusinessObjectName;

    @ApiModelProperty(value = "引用的业务对象的字段", position = 15)
    private String refField;

    @ApiModelProperty(value = "规则条件", position = 16)
    private DprRuleConditionEnum dprRuleCondition;
    private String dprRuleConditionName;

    @ApiModelProperty(value = "取值方式", position = 17)
    private DprRuleValueTypeEnum dprRuleValueType;
    private String dprRuleValueTypeName;

    @ApiModelProperty(value = "数据集类型", position = 18)
    private String dataSet;

    @ApiModelProperty(value = "规则值", position = 19)
    private String dprRuleValue;
    private String dprRuleValueName;

    @ApiModelProperty(value = "规则描述", position = 20)
    private String dprRuleDeclare;

    @ApiModelProperty(value = "规则顺序", position = 21)
    private Integer ruleOrder;

    @ApiModelProperty(value = "特用字段1", position = 91)
    private String bs1;

    @ApiModelProperty(value = "特用字段2", position = 92)
    private String bs2;

    @ApiModelProperty(value = "特用字段3", position = 93)
    private String bs3;

    public String getGroupRelationName() {
        if (groupRelationName == null && groupRelation != null) {
            return groupRelation.getValueDescription();
        }
        return groupRelationName;
    }

    public String getDprRuleConditionName() {
        if (dprRuleConditionName == null && dprRuleCondition != null) {
            return dprRuleCondition.getValueDescription();
        }
        return dprRuleConditionName;
    }

    public String getDprRuleValueTypeName() {
        if (dprRuleValueTypeName == null && dprRuleValueType != null) {
            return dprRuleValueType.getValueDescription();
        }
        return dprRuleValueTypeName;
    }
}
