package com.elitescloud.cloudt.system.model.vo.resp.extend;

import com.elitescloud.cloudt.system.model.vo.save.extend.AlertConfigWxWorkSaveVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 预警配置.
 *
 * @author Kaiser（wang shao）
 * @date 2023/10/26
 */
@Data
@ApiModel(description = "预警配置")
public class AlertRespVO implements Serializable {
    private static final long serialVersionUID = -7078452154923768527L;

    /**
     * ID
     */
    @ApiModelProperty(value = "ID")
    private Long id;

    /**
     * 业务类型
     */
    @ApiModelProperty(value = "业务类型", position = 1, required = true)
    private String businessType;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用，默认是", position = 2)
    private Boolean enabled;

    /**
     * 企业微信配置
     */
    @ApiModelProperty(value = "企业微信配置", position = 3)
    private AlertConfigWxWorkRespVO wxWorkRespVO;

    @ApiModelProperty(value = "钉钉配置", position = 3)
    private AlertConfigDingdingRespVO dingdingRespVO;

    /**
     * 说明
     */
    @ApiModelProperty(value = "说明", position = 4)
    private String description;
}
