package com.elitescloud.cloudt.system.model.vo.resp.extend;

import cn.hutool.core.util.ObjectUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @Auther: Mark
 * @Date: 2024/12/13 17:16
 * @Description:
 */
@Data
@ApiModel("接口分组")
public class FolderSaveParamVO {


    @ApiModelProperty(value = "唯一标识")
    private Long id;

    @ApiModelProperty(value = "平台编码")
    @NotBlank(message = "平台编码必填")
    private String platformCode;

    @ApiModelProperty(value = "目录名称")
    @NotBlank(message = "目录名称必填")
    private String folderName;

    @ApiModelProperty(value = "服务url前缀")
    private String serverUrl;

    @ApiModelProperty(value = "认证方式")
    @NotBlank(message = "认证方式必填")
    private String authMethod;

    @ApiModelProperty(value = "BasicAuth 认证账号")
    private BasicAuthAccountVO basicAuthAccount;

    @ApiModelProperty(value = "OAuth2.0 认证账号")
    private OAuth2AccountVO oauth2Account;

    @ApiModelProperty(value = "文档说明(支持markdown)")
    private String description;

    @ApiModelProperty(value = "备注")
    private String remark;

    public boolean isNew() {
        return ObjectUtil.isNull(id);
    }
}
