package com.elitescloud.cloudt.system.model.vo.resp.extend;

import com.elitescloud.cloudt.system.common.DataType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/12/13 16:17
 * @Description:
 */

@Data
@ApiModel("表单参数")
public class FormColumnDefinition {

    @ApiModelProperty("字段")
    private String columnKey;

    @ApiModelProperty("字段中文")
    private String columnName;

    @ApiModelProperty("数据类型")
    private DataType dataType;

    @ApiModelProperty("描述说明：默认值、注意事项等")
    private String description;

    @ApiModelProperty("是否必填")
    private boolean required;

    @ApiModelProperty("固定值")
    private String fixedValue;

    @ApiModelProperty("子集，数据类型为对象或数组时有数据")
    private List<FormColumnDefinition> children;
}
