package com.elitescloud.cloudt.system.model.vo.resp.extend;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 税率详细信息.
 *
 * @author Kaiser（wang shao）
 * 2023/1/13
 */
@Data
@ApiModel(description = "税率详细信息")
public class TaxRateDetailRespVO implements Serializable {
    private static final long serialVersionUID = -1462445999850067967L;

    /**
     * 记录ID
     */
    @ApiModelProperty(value = "记录ID", position = 1)
    private Long id;

    /**
     * 税率编码
     */
    @ApiModelProperty(value = "税率编码", position = 2)
    private String taxRateNo;

    /**
     * 税率类型
     */
    @ApiModelProperty(value = "税率类型，UDC[cloudt-system:taxRateType]", position = 3)
    private String taxRateType;
    private String taxRateTypeName;

    /**
     * 税率说明
     */
    @ApiModelProperty(value = "税率说明", position = 4)
    private String taxRateDesc;

    /**
     * 生效日期
     */
    @ApiModelProperty(value = "生效日期", position = 5)
    private LocalDateTime validFrom;

    /**
     * 失效日期
     */
    @ApiModelProperty(value = "失效日期", position = 6)
    private LocalDateTime validTo;

    /**
     * 税率值
     */
    @ApiModelProperty(value = "税率值", position = 7)
    private BigDecimal taxRateValue;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 8)
    private Boolean enabled;
}
