package com.elitescloud.cloudt.system.model.vo.resp.menu;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 获取菜单的节点详细信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/28
 */
@Getter
@Setter
@ApiModel(description = "获取菜单的节点详细信息")
public class CustomMenuNodeDetailRespVO implements Serializable {
    private static final long serialVersionUID = -5682588283492908084L;

    @ApiModelProperty(value = "ID", position = 1)
    private Long id;

    private String nodeType;

    @ApiModelProperty(value = "分组编码", position = 2)
    private String parentMenuCode;

    @ApiModelProperty(value = "分组名称", position = 2)
    private String parentMenuName;

    @ApiModelProperty(value = "菜单编码", position = 3)
    private String menuCode;

    @ApiModelProperty(value = "菜单名称", position = 4)
    private String menuName;

    @ApiModelProperty(value = "自定义名称", position = 5)
    private String customName;

    @ApiModelProperty(value = "是否启用", position = 6)
    private Boolean enabled;

    @ApiModelProperty(value = "排序", position = 7)
    private Integer sortNo;

    @ApiModelProperty(value = "图标", position = 8)
    private String icon;

    @ApiModelProperty(value = "下级节点", position = 11)
    private List<CustomMenuNodeDetailRespVO> children;

    @ApiModelProperty(value = "下级数量", position = 12)
    private Long childrenNum;
}
