package com.elitescloud.cloudt.system.model.vo.resp.menu;

import com.elitescloud.cloudt.system.service.common.constant.MenuTreeNodeType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.List;

/**
 * 菜单树节点.
 *
 * @author Kaiser（wang shao）
 * 2022/9/19
 */
@Data
@ApiModel(description = "自定义菜单树节点")
public class MenuTreeCustomRespVO implements Serializable {
    private static final long serialVersionUID = -6044178680494632724L;

    /**
     * 菜单编码
     */
    @ApiModelProperty(value = "菜单编码", position = 1)
    private String menuCode;

    /**
     * 是否是自定义菜单
     */
    @ApiModelProperty(value = "是否是自定义菜单", position = 1)
    private Boolean custom;

    /**
     * 菜单名称
     */
    @ApiModelProperty(value = "菜单名称", position = 2)
    private String menuName;

    /**
     * 菜单名称
     */
    @ApiModelProperty(value = "原菜单名称", position = 3)
    private String originalMenuName;

    /**
     * 节点类型
     * {@link MenuTreeNodeType}
     */
    @ApiModelProperty(value = "节点类型", position = 4)
    private String nodeType;

    /**
     * 父节点编码
     */
    @ApiModelProperty(value = "父节点编码", position = 5)
    private String parentMenuCode;

    /**
     * 菜单图标
     */
    @ApiModelProperty(value = "菜单图标", position = 6)
    private String menusIcon;

    /**
     * 菜单图标
     */
    @ApiModelProperty(value = "原菜单图标", position = 7)
    private String originalMenusIcon;

    /**
     * 是否隐藏
     */
    @ApiModelProperty(value = "是否隐藏", position = 8)
    private Boolean hidden;

    /**
     * 是否隐藏
     */
    @ApiModelProperty(value = "是否已禁用", position = 9)
    private Boolean enabled;

    /**
     * 排序
     */
    @ApiModelProperty(value = "排序", position = 10)
    private Integer sortNo;

    /**
     * 是否隐藏
     */
    @ApiModelProperty(value = "是否有子节点", position = 11)
    private Boolean hasChildren;
    /**
     * 子节点列表
     */
    @ApiModelProperty(value = "子节点列表", position = 12)
    private List<MenuTreeCustomRespVO> children;

    public Boolean getHasChildren() {
        if (children != null && children.size() > 0) {
            return true;
        }
        return hasChildren;
    }

    public String getParentMenuCode() {
        if (!StringUtils.hasText(parentMenuCode)) {
            return null;
        }
        return parentMenuCode;
    }
}
