package com.elitescloud.cloudt.system.model.vo.resp.message;

import com.elitescloud.cloudt.system.constant.MsgSendTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.io.Serializable;

/**
 * 消息测试结果.
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/27
 */
@Getter
@Setter
@ApiModel(description = "消息测试结果")
@AllArgsConstructor
@NoArgsConstructor
public class MsgTestRespVO implements Serializable {
    private static final long serialVersionUID = 8980593103412987501L;

    @ApiModelProperty(value = "渠道类型", position = 1)
    private MsgSendTypeEnum msgSendType;

    @ApiModelProperty(value = "是否成功", position = 2)
    private Boolean success;

    @ApiModelProperty(value = "失败信息", position = 3)
    private String failMsg;

    @ApiModelProperty(value = "耗时，单位毫秒", position = 4)
    private Long cost;
}
