package com.elitescloud.cloudt.system.model.vo.resp.permission;

import com.elitescloud.boot.common.param.TreeRespParam;
import com.elitescloud.cloudt.platform.model.vo.resp.MenuOperationRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.api.SysMenuApiRespVO;
import com.elitescloud.cloudt.system.service.common.constant.MenuTreeNodeType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 数据权限节点.
 *
 * @author Kaiser（wang shao）
 * @date 2023/11/17
 */
@Data
@ApiModel(description = "数据权限节点")
public class DataPermissionTreeNodeRespVO extends TreeRespParam<DataPermissionTreeNodeRespVO> {
    private static final long serialVersionUID = 8023832272332157727L;

    /**
     * 路由地址
     */
    @ApiModelProperty(value = "路由地址", position = 21)
    private String route;

    /**
     * 节点类型
     * {@link MenuTreeNodeType}
     */
    @ApiModelProperty(value = "节点类型", position = 22)
    private String nodeType;
    @ApiModelProperty(value = "节点类型名称", position = 22)
    private String nodeTypeName;

    @ApiModelProperty(value = "是否为挂载节点", position = 23)
    private Boolean refNode;

    @ApiModelProperty(value = "关联的权限节点", position = 24)
    private String refPermission;
    private String refPermissionName;

    /**
     * 规则数量
     */
    @ApiModelProperty(value = "规则数量", position = 25)
    private Long ruleNum;

    @ApiModelProperty(value = "图标", position = 26)
    private String icon;

    @ApiModelProperty(value = "业务对象编码", position = 27)
    private String businessObjectCode;

    /**
     * API详细信息
     */
    @ApiModelProperty(value = "API详细信息", position = 31)
    @Deprecated(since = "3.3.0")
    private SysMenuApiRespVO apiDetail;

    /**
     * 业务对象操作的详细信息
     */
    @ApiModelProperty(value = "业务对象操作的详细信息", position = 31)
    private MenuOperationRespVO operationDetail;
}
