package com.elitescloud.cloudt.system.model.vo.resp.sys;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 选择器分页查询信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/17
 */
@Getter
@Setter
@ApiModel(description = "选择器分页查询信息")
public class DataSelectorPagedRespVO implements Serializable {
    private static final long serialVersionUID = -614692784461186658L;

    @ApiModelProperty(value = "ID", position = 1)
    private Long id;

    @ApiModelProperty(value = "分组编码", position = 2)
    private String groupCode;

    @ApiModelProperty(value = "分组名称", position = 3)
    private String groupName;

    @ApiModelProperty(value = "选择器编码", position = 4)
    private String selectorCode;

    @ApiModelProperty(value = "选择器名称", position = 5)
    private String selectorName;

    @ApiModelProperty(value = "是否启用", position = 6)
    private Boolean enabled;

    @ApiModelProperty(value = "是否是公共组件", position = 7)
    private Boolean component;

    @ApiModelProperty(value = "组件编码", position = 8)
    private String componentCode;

    @ApiModelProperty(value = "数据接口API", position = 9)
    private String dataApi;

    @ApiModelProperty(value = "数据接口请求方式", position = 10)
    private String dataApiMethod;

    @ApiModelProperty(value = "创建时间", position = 21)
    private LocalDateTime createTime;

    @ApiModelProperty(value = "修改时间", position = 22)
    private LocalDateTime modifyTime;
}
