package com.elitescloud.cloudt.system.model.vo.resp.sys;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.cloudt.system.model.vo.resp.user.UserDetailRespVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;
import java.util.Set;

/**
 * 子账号详细信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/29
 */
@Getter
@Setter
@ApiModel(description = "子账号详细信息")
public class SubUserDetailRespVO implements Serializable {
    private static final long serialVersionUID = -1529465543281420710L;

    @ApiModelProperty(value = "账户信息", position = 1)
    private UserDetailRespVO user;

    @ApiModelProperty(value = "角色信息", position = 2)
    private List<IdCodeNameParam> roleList;

    @ApiModelProperty(value = "菜单编码", position = 3)
    private Set<String> menuCodes;
}
