package com.elitescloud.cloudt.system.model.vo.save.dpr;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 数据权限保存信息.
 *
 * @author Kaiser（wang shao）
 * @date 3/29/2023
 */
@Data
@ApiModel(description = "数据权限保存信息")
public class SysDprSaveVO implements Serializable {
    private static final long serialVersionUID = -8220968718281066641L;

    /**
     * 角色ID
     */
    @ApiModelProperty(value = "角色ID", position = 1, required = true)
    @NotNull(message = "角色ID为空")
    private Long roleId;

    /**
     * 菜单编码
     */
    @ApiModelProperty(value = "菜单编码", position = 2, required = true)
    @NotBlank(message = "菜单编码为空")
    private String menuCode;

    /**
     * 接口编码
     */
    @ApiModelProperty(value = "接口编码", position = 3, required = true)
    @NotBlank(message = "接口编码为空")
    private String apiCode;

    /**
     * 数据范围
     */
    @ApiModelProperty(value = "数据范围", position = 4)
    private String range;

    /**
     * 自定义规则列表
     */
    @ApiModelProperty(value = "自定义规则列表", position = 5)
    @Valid
    private List<SysDprApiCustomRuleSaveVO> customRuleList;

    /**
     * 字段权限列表
     */
    @ApiModelProperty(value = "字段权限列表", position = 6)
    @Valid
    private List<SysDprApiFieldSaveVO> fieldList;
}
