package com.elitescloud.cloudt.system.model.vo.save.extend;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 预警配置.
 *
 * @author Kaiser（wang shao）
 * @date 2023/10/26
 */
@Data
@ApiModel(description = "预警配置")
public class AlertSaveVO implements Serializable {
    private static final long serialVersionUID = -7078452154923768527L;

    /**
     * ID，修改时不可为空
     */
    @ApiModelProperty(value = "ID，修改时不可为空")
    private Long id;

    /**
     * 业务类型
     */
    @ApiModelProperty(value = "业务类型", position = 1, required = true)
    private String businessType;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用，默认是", position = 2)
    private Boolean enabled;

    /**
     * 企业微信配置
     */
    @ApiModelProperty(value = "企业微信配置", position = 11)
    private AlertConfigWxWorkSaveVO wxWorkSaveVO;

    @ApiModelProperty(value = "钉钉配置", position = 12)
    private AlertConfigDingdingSaveVO dingdingWorkSaveVO;

    /**
     * 说明
     */
    @ApiModelProperty(value = "说明", position = 21)
    private String description;
}
