package com.elitescloud.cloudt.system.model.vo.save.extend;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 企业微信基本保存信息.
 *
 * @author Kaiser（wang shao）
 * @date 2/10/2023
 */
@Data
public abstract class BaseWecomAppSaveVO {

    /**
     * ID
     */
    @ApiModelProperty(value = "ID，修改时不为空", position = 1)
    private Long id;

    /**
     * 账号名称
     */
    @ApiModelProperty(value = "账号名称", position = 2, required = true)
    @NotBlank(message = "账号名称为空")
    private String name;

    /**
     * 企业ID
     */
    @ApiModelProperty(value = "企业ID", position = 3, required = true)
    @NotBlank(message = "企业ID为空")
    private String corpid;

    /**
     * 应用ID
     */
    @ApiModelProperty(value = "应用ID", position = 4)
    private String agentId;

    /**
     * 应用秘钥
     */
    @ApiModelProperty(value = "应用秘钥", position = 5, required = true)
    @NotBlank(message = "应用秘钥为空")
    private String corpsecret;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 6)
    private Boolean enabled;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注", position = 11)
    private String remark;
}
