package com.elitescloud.cloudt.system.model.vo.save.menu;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 菜单分组保存信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/28
 */
@Getter
@Setter
@ApiModel(description = "菜单分组保存信息")
public class CustomMenuGroupSaveVO implements Serializable {
    private static final long serialVersionUID = -5783094069446566217L;

    @ApiModelProperty(value = "ID，编辑时不可为空", position = 1)
    private Long id;

    @ApiModelProperty(value = "所属分组的编码，一级分组时可为空", position = 2)
    private String parentMenuCode;

    @ApiModelProperty(value = "菜单名称", position = 3, required = true)
    @NotBlank(message = "名称为空")
    private String menuName;

    @ApiModelProperty(value = "菜单编码", position = 4, required = true)
    @NotBlank(message = "编码为空")
    private String menuCode;

    @ApiModelProperty(value = "排序", position = 5)
    private Integer sortNo;

    @ApiModelProperty(value = "是否启用", position = 6)
    private Boolean enabled;

    @ApiModelProperty(value = "图标", position = 7)
    private String icon;
}
