package com.elitescloud.cloudt.system.model.vo.save.role;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serial;
import java.io.Serializable;
import java.util.Set;

/**
 * 通过组织授权用户角色.
 *
 * @author Kaiser（wang shao）
 * @date 2025/8/22 周五
 */
@Getter
@Setter
public class OrgRolePermissionSaveVO implements Serializable {
    @Serial
    private static final long serialVersionUID = -6446787953012825761L;

    /**
     * 组织编码
     */
    @ApiModelProperty(value = "组织编码")
    private Set<String> orgCodes;

    /**
     * 角色编码
     */
    @ApiModelProperty(value = "角色编码")
    private Set<String> roleCodes;

    /**
     * 是否包含下级组织
     */
    @ApiModelProperty(value = "withChildrenOrg")
    private Boolean withChildrenOrg;
}
