package com.elitescloud.cloudt.system.model.vo.save.role;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

/**
 * 角色组.
 *
 * @author Kaiser（wang shao）
 * @date 2023/11/24
 */
@Data
@ApiModel(description = "角色组")
public class RoleGroupSaveVO implements Serializable {
    private static final long serialVersionUID = -7709240127331148247L;

    @ApiModelProperty(value = "ID，编辑时不可为空", position = 1)
    private Long id;

    @ApiModelProperty(value = "分组编码", position = 2)
    private String groupCode;

    @ApiModelProperty(value = "分组名称", position = 3, required = true)
    @NotBlank(message = "分组名称不能为空")
    private String groupName;

    @ApiModelProperty(value = "启用状态", position = 4)
    private Boolean enabled;

    @ApiModelProperty(value = "描述", position = 5)
    private String description;

    @ApiModelProperty(value = "关联的组织编码", position = 11)
    private List<String> relatedOrgCodes;
}
