package com.elitescloud.cloudt.system.model.vo.save.sys;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 数据选择器分组保存信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/16
 */
@Getter
@Setter
@ApiModel(description = "数据选择器分组保存信息")
public class DataSelectorGroupSaveVO implements Serializable {
    private static final long serialVersionUID = 555512598320062534L;

    @ApiModelProperty(value = "ID，编辑时不可为空", position = 1)
    private Long id;

    @NotBlank(message = "分组编码为空")
    @ApiModelProperty(value = "分组编码，不可为空且唯一，设置后不可修改", position = 2, required = true)
    private String groupCode;

    @ApiModelProperty(value = "分组名称", position = 3, required = true)
    @NotBlank(message = "分组名称不能为空")
    private String groupName;

    @ApiModelProperty(value = "启用状态", position = 4)
    private Boolean enabled;

    @ApiModelProperty(value = "排序", position = 5)
    private Integer sortNo;

    @ApiModelProperty(value = "描述", position = 11)
    private String description;
}
