package com.elitescloud.cloudt.system.modules.dpr;

import com.elitescloud.boot.datasecurity.common.extension.DprValueType;

/**
 * 系统内置的数据权限规则值.
 *
 * @author Kaiser（wang shao）
 * @date 2024/11/23
 */
public enum SysDprValueType implements DprValueType {
    DPR_SYS_INTERNALLY_ALL("DPR_SYS_INTERNALLY_ALL", "全部", "所有数据", 0, true),

    DPR_SYS_INTERNALLY_EMPLOYEE("DPR_SYS_INTERNALLY_EMPLOYEE", "本人-员工(ID)", "本人的员工身份创建的数据", 1, true),
    DPR_SYS_INTERNALLY_EMPLOYEE_SUB("DPR_SYS_INTERNALLY_EMPLOYEE_SUB", "本人下级-员工(ID)", "本人的下级员工身份创建的数据", 2, true),
    DPR_SYS_INTERNALLY_EMPLOYEE_LOCAL_SUB("DPR_SYS_INTERNALLY_EMPLOYEE_LOCAL_SUB", "本人及下级-员工(ID)", "本人及下级员工身份所创建的数据", 3, true),
    DPR_SYS_INTERNALLY_USER("DPR_SYS_INTERNALLY_USER", "本人-账号(ID)", "本人账号创建的数据", 4, true),
    DPR_SYS_INTERNALLY_USER_SUB("DPR_SYS_INTERNALLY_USER_SUB", "本人下级-账号(ID)", "本人下级员工的账号创建的数据", 5, true),
    DPR_SYS_INTERNALLY_USER_LOCAL_SUB("DPR_SYS_INTERNALLY_USER_LOCAL_SUB", "本人及下级-账号(ID)", "本人及下级员工的账号创建的数据", 6, true),
    /**
     * @deprecated 改为 {@link SysDprValueType.DPR_SYS_INTERNALLY_DYNAMIC}动态获取
     */
    @Deprecated(since = "3.3.0")
    DPR_SYS_INTERNALLY_EMPLOYEE_SALESMAN("DPR_SYS_INTERNALLY_EMPLOYEE_SALESMAN", "本人-员工关联的业务员(ID)", "本人de业务员身份创建的数据", 7, true),

    DPR_SYS_INTERNALLY_ORG("DPR_SYS_INTERNALLY_ORG", "本人-员工所在行政组织(ID)", "本人所在的行政组织所创建的数据", 8, true),
    DPR_SYS_INTERNALLY_ORG_SUB("DPR_SYS_INTERNALLY_ORG_SUB", "本人-员工下级行政组织", "本人的下级行政组织所创建的数据", 9, true),
    DPR_SYS_INTERNALLY_ORG_LOCAL_SUB("DPR_SYS_INTERNALLY_ORG_LOCAL_SUB", "本人-员工所在组织及下级行政组织", "本人所在行政组织及其下级行政组织所创建的数据", 10, true),

    DPR_SYS_INTERNALLY_OU("DPR_SYS_INTERNALLY_OU", "本人-所在公司（当前组织的公司）", "本人当前公司创建的数据", 11, true),
    DPR_SYS_INTERNALLY_OU_ALL("DPR_SYS_INTERNALLY_OU_ALL", "本人-所在公司(全部组织的公司)", "本人所有公司创建的数据", 12, true),
    DPR_SYS_INTERNALLY_EMP_GROUP("DPR_SYS_INTERNALLY_EMP_GROUP", "本人-所在员工组", "本人所在员工组的员工所创建的数据", 12, true),

    DPR_SYS_INTERNALLY_DYNAMIC("DPR_SYS_INTERNALLY_DYNAMIC", "动态获取", "根据账户的其它身份动态获取", 21, true),
    ;

    private final String code;
    private final String name;
    private final String description;
    private final float sortNo;
    private final boolean enabled;

    SysDprValueType(String code, String name, String description, float sortNo, boolean enabled) {
        this.code = code;
        this.name = name;
        this.description = description;
        this.sortNo = sortNo;
        this.enabled = enabled;
    }


    @Override
    public String code() {
        return code;
    }

    public String showName() {
        return name;
    }


    @Override
    public String description() {
        return description;
    }

    @Override
    public float sortNo() {
        return sortNo;
    }

    @Override
    public boolean enabled() {
        return enabled;
    }
}
