package com.elitescloud.cloudt.system.modules.dpr.strategy;

import com.elitescloud.cloudt.system.service.EmployeeQueryService;
import com.elitescloud.cloudt.system.service.OrgQueryService;

import java.util.Collections;
import java.util.List;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023-12-22 15:56
 */
public class DprSysInternallyStrategyUtil {

    /**
     * 获取下属员工的用户ID
     *
     * @param userId 当前用户ID
     * @return 下属员工的用户ID
     */
    public static List<Long> querySubEmployeeUserId(EmployeeQueryService employeeQueryService, Long userId) {
        return employeeQueryService.getUserIdByLeaderUserId(userId).getData();
    }

    /**
     * 获取自己及下属员工的用户ID
     *
     * @param userId 当前用户ID
     * @return 自己及下属员工的用户ID
     */
    public static List<Long> querySubEmployeeUserIdAndSelf(EmployeeQueryService employeeQueryService, Long userId) {
        var subUserIds = querySubEmployeeUserId(employeeQueryService, userId);
        return subUserIds;
    }


    /**
     * 获取直属下级组织ID
     * <p>
     * 直属组织
     *
     * @param orgId 当前组织ID
     * @return 组织ID集合
     */
    public static List<Long> querySubOrgId(OrgQueryService orgQueryService, Long orgId) {
        if (orgId == null) {
            return Collections.emptyList();
        }
        return orgQueryService.querySubOrgIds(orgId).getData();
    }

    /**
     * 获取所有下级组织ID
     * <p>
     * 下属组织
     *
     * @param orgId 当前组织ID
     * @return 组织ID集合
     */
    public static List<Long> queryBelongOrgId(OrgQueryService orgQueryService, Long orgId) {
        if (orgId == null) {
            return Collections.emptyList();
        }
        return orgQueryService.queryBelongOrgIds(orgId).getData();
    }
}
