package com.elitescloud.cloudt.system.modules.dpr.strategy.impl;

import com.elitescloud.boot.datasecurity.common.extension.DprValueResolverSPI;
import com.elitescloud.boot.datasecurity.common.extension.DprValueType;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.dto.SysUserType;
import com.elitescloud.cloudt.system.modules.dpr.SysDprValueType;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/14
 */
@Slf4j
@Component
public class DprSysInternallyAll implements DprValueResolverSPI {

    @Override
    public @NotEmpty DprValueType[] valueTypes() {
        return new DprValueType[]{SysDprValueType.DPR_SYS_INTERNALLY_ALL};
    }

    @Override
    public DprRuleValue resolve(@NotNull DprValueType dprValueType, @NotNull GeneralUserDetails userInfo, @NotNull SysDprRoleApiDataRuleListQueryDTO ruleDTO) {
        DprRuleValue dprRuleValue = new DprRuleValue();
        dprRuleValue.setValueType(SysDprValueType.DPR_SYS_INTERNALLY_ALL);
        dprRuleValue.setValue(SysDprValueType.DPR_SYS_INTERNALLY_ALL.code());
        return dprRuleValue;
    }
}
