package com.elitescloud.cloudt.system.modules.dpr.strategy.impl;

import com.elitescloud.boot.datasecurity.common.extension.DprValueResolverSPI;
import com.elitescloud.boot.datasecurity.common.extension.DprValueType;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.modules.dpr.SysDprValueType;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * @author : chen.niu
 * @description : 本人-员工
 * @date : 2023-12-22 13:23
 */
@Service
@Slf4j
public class DprSysInternallyEmployee implements DprValueResolverSPI {

    @Override
    public @NotEmpty DprValueType[] valueTypes() {
        return new DprValueType[]{SysDprValueType.DPR_SYS_INTERNALLY_EMPLOYEE};
    }

    @Override
    public DprRuleValue resolve(@NotNull DprValueType dprValueType, @NotNull GeneralUserDetails generalUserDetails, @NotNull SysDprRoleApiDataRuleListQueryDTO sysDprRoleApiDataRuleListQueryDTO) {
        DprRuleValue dprRuleValueSysInternallyBo = new DprRuleValue();
        var employeeId = generalUserDetails.getUser().getEmployeeId();
        if (employeeId != null) {
            dprRuleValueSysInternallyBo.setValue(employeeId.toString());
        } else {
            log.error("数据权限错误：账号没有员工信息D");
        }

        return dprRuleValueSysInternallyBo;
    }
}
