package com.elitescloud.cloudt.system.modules.dpr.strategy.impl;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjUtil;
import com.elitescloud.boot.datasecurity.common.extension.DprValueResolverSPI;
import com.elitescloud.boot.datasecurity.common.extension.DprValueType;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.modules.dpr.RoleAppApiDataPermissionUtil;
import com.elitescloud.cloudt.system.modules.dpr.SysDprValueType;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023-12-22 13:25
 */
@Service
@Slf4j
public class DprSysInternallyOu implements DprValueResolverSPI {

    @Override
    public @NotEmpty DprValueType[] valueTypes() {
        return new DprValueType[]{SysDprValueType.DPR_SYS_INTERNALLY_OU};
    }

    @Override
    public DprRuleValue resolve(@NotNull DprValueType dprValueType, @NotNull GeneralUserDetails userInfo, @NotNull SysDprRoleApiDataRuleListQueryDTO ruleDTO) {
        DprRuleValue rule = new DprRuleValue();

        // 所在公司
        if (RoleAppApiDataPermissionUtil.isIdField(ruleDTO.getDprRuleField())) {
            rule.setValue(ObjUtil.defaultIfNull(userInfo.getUser().getOuId(), -1L));
        } else {
            rule.setValue(CharSequenceUtil.blankToDefault(userInfo.getUser().getOuCode(), "unknown"));
        }

        return rule;
    }
}
