package com.elitescloud.cloudt.system.modules.dpr.strategy.impl;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.datasecurity.common.extension.DprValueResolverSPI;
import com.elitescloud.boot.datasecurity.common.extension.DprValueType;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.constant.OrgType;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;
import com.elitescloud.cloudt.system.modules.dpr.RoleAppApiDataPermissionUtil;
import com.elitescloud.cloudt.system.modules.dpr.SysDprValueType;
import com.elitescloud.cloudt.system.service.repo.OrgRepoProc;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023-12-22 13:25
 */
@Service
@Slf4j
public class DprSysInternallyOuAll implements DprValueResolverSPI {
    @Autowired
    private OrgRepoProc orgRepoProc;

    @Override
    public @NotEmpty DprValueType[] valueTypes() {
        return new DprValueType[]{SysDprValueType.DPR_SYS_INTERNALLY_OU_ALL};
    }

    @Override
    public DprRuleValue resolve(@NotNull DprValueType dprValueType, @NotNull GeneralUserDetails userInfo, @NotNull SysDprRoleApiDataRuleListQueryDTO ruleDTO) {
        DprRuleValue rule = new DprRuleValue();

        // 所在公司
        if (RoleAppApiDataPermissionUtil.isIdField(ruleDTO.getDprRuleField())) {
            if (userInfo.getUser() == null || userInfo.getUser().getOrgList() == null || userInfo.getUser().getOrgList().isEmpty()) {
                log.error("用户信息没有获取到组织数据");
            } else {
                List<SysOrgBasicDTO> orgList = userInfo.getUser().getOrgList();
                List<Long> orgIds = orgList.stream().map(SysOrgBasicDTO::getId).collect(Collectors.toList());
                Map<Long, IdCodeNameParam> company = orgRepoProc.queryParentNameForType(orgIds, OrgType.COMPANY.getValue(), true);
                if (company != null) {
                    List<Long> ouIds = company.values().stream().map(IdCodeNameParam::getId).collect(Collectors.toList());
                    rule.setValue(ouIds);
                } else {
                    log.error("用户信息没有获取到组织的公司数据 ID");
                }
            }
        } else {
            if (userInfo.getUser() == null || userInfo.getUser().getOrgList() == null || userInfo.getUser().getOrgList().isEmpty()) {
                log.error("用户信息没有获取到组织数据，查询条件");
            } else {
                List<SysOrgBasicDTO> orgList = userInfo.getUser().getOrgList();
                List<Long> orgIds = orgList.stream().map(SysOrgBasicDTO::getId).collect(Collectors.toList());
                Map<Long, IdCodeNameParam> company = orgRepoProc.queryParentNameForType(orgIds, OrgType.COMPANY.getValue(), true);
                if (company != null) {
                    List<String> ouCodes =
                            company.values().stream().map(IdCodeNameParam::getCode).collect(Collectors.toList());
                    rule.setValue(ouCodes);
                } else {
                    log.error("用户信息没有获取到组织的公司数据 ID，查询条件");
                }
            }
        }

        return rule;
    }
}
