package com.elitescloud.cloudt.system.modules.message.controller;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023/5/23 13:43
 */

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.lang.Assert;
import cn.zhxu.bs.SearchResult;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.constant.MsgSendStateEnum;
import com.elitescloud.cloudt.system.constant.MsgSendTypeEnum;
import com.elitescloud.cloudt.system.modules.message.sbean.SysMsgSendRecordDtlQueryBean;
import com.elitescloud.cloudt.system.modules.message.sbean.SysMsgSendRecordQueryBean;
import com.elitescloud.cloudt.system.modules.message.service.SysMsgSendRecordService;
import com.elitescloud.cloudt.system.modules.message.vo.request.SysMsgSendRecordDeleteVO;
import com.elitescloud.cloudt.system.modules.message.vo.request.SysMsgSendRecordDtlInteriorQueryVO;
import com.elitescloud.cloudt.system.modules.message.vo.request.SysMsgSendRecordDtlInteriorUserQueryVO;
import com.elitescloud.cloudt.system.modules.message.vo.request.SysMsgSendRecordQueryVO;
import com.elitescloud.cloudt.system.vo.SysUdcVO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;
import java.util.Set;

/**
 * @author : chen.niu
 * @description : 消息发送记录
 * @date : 2023/5/23 10:07
 */
@RestController
@RequestMapping("/msg/sysMsgSendRecord")
@Api(tags = "消息发送记录")
@Validated
public class SysMsgSendRecordController {

    private final SysMsgSendRecordService service;

    @Autowired
    public SysMsgSendRecordController(SysMsgSendRecordService service) {
        this.service = service;
    }

    @PostMapping("/query")
    @ApiOperation(value = "分页查询发送记录主表")
    @ApiOperationSupport(order = 1)
    public ApiResult<SearchResult<SysMsgSendRecordQueryBean>> sysMsgSendRecordQuery(
            @RequestBody SysMsgSendRecordQueryVO queryVO) {
        return service.sysMsgSendRecordQuery(queryVO);
    }

    @GetMapping("/sysMsgSendRecordDtl/sendRecord/{id}")
    @ApiOperation(value = " 消息发送主表数据id查询发送明细")
    @ApiOperationSupport(order = 2)
    public ApiResult<List<SysMsgSendRecordDtlQueryBean>> sysMsgSendRecordDtlById(
            @PathVariable("id") Long sendRecordId) {
        return service.sysMsgSendRecordDtlByRecordId(sendRecordId);
    }


    @PostMapping("/sysMsgSendRecordDtl/interior/query")
    @ApiOperation(value = "根据接收人id查询对应的站内消息，分页查询")
    @ApiOperationSupport(order = 3)
    public ApiResult<SearchResult<SysMsgSendRecordDtlQueryBean>>
    sysMsgSendRecordDtlInteriorQuery(
            @RequestBody SysMsgSendRecordDtlInteriorQueryVO qvo) {
        return service.sysMsgSendRecordDtlInteriorQuery(qvo);
    }

    @PostMapping("/sysMsgSendRecordDtl/interior/user/query")
    @ApiOperation(value = "根据当前用户-需要登录-id查询对应的站内消息，分页查询")
    @ApiOperationSupport(order = 3)
    public ApiResult<SearchResult<SysMsgSendRecordDtlQueryBean>> sysMsgSendRecordDtlInteriorQuery(
            @RequestBody SysMsgSendRecordDtlInteriorUserQueryVO qUserVo) {
        SysMsgSendRecordDtlInteriorQueryVO qvo = new SysMsgSendRecordDtlInteriorQueryVO();
        BeanUtil.copyProperties( qUserVo,qvo);
        qvo.setCurrent(qUserVo.current);
        var currentUser = SecurityContextUtil.currentUserIfUnauthorizedThrow();

        qvo.setSendState(MsgSendStateEnum.OK.name());
        qvo.setRecipientUserCode(currentUser.getUsername());
        return service.sysMsgSendRecordDtlInteriorQuery(qvo);
    }
    @PostMapping("/sysMsgSendRecordDtl/select/{rDtlId}")
    @ApiOperation(value = "根据id查询对应的明细的详情 ")
    @ApiOperationSupport(order = 3)
    public ApiResult<SysMsgSendRecordDtlQueryBean> sysMsgSendRecordDtlInteriorQuery(
            @PathVariable Long rDtlId ) {
        return service.sysMsgSendRecordDtlInteriorByDtlIdQuery(rDtlId,null);
    }

    @ApiOperation(value = "根据消息id获取详细详情 ")
    @ApiOperationSupport(order = 3)
    @GetMapping(value = "/receiver/msg")
    public ApiResult<SysMsgSendRecordDtlQueryBean> getReceivedMsg(@NotBlank(message = "消息ID为空") @RequestParam(name = "msgId") String msgId) {
        return service.getRecordDetail(msgId);
    }

    @ApiOperation(value = "获取待读的数量")
    @ApiOperationSupport(order = 4)
    @GetMapping(value = "/toRead")
    public ApiResult<Long> countToRead() {
        return service.countToView();
    }

    @PutMapping("/sysMsgSendRecordDtl/{id}/interior/read")
    @ApiOperation(value = " 站内消息已读修改")
    @ApiOperationSupport(order = 5)
    public ApiResult<Boolean> interiorReadUpdate(@PathVariable("id") Long id) {

        return service.interiorReadUpdate(id,true);
    }

    @ApiOperation(value = " 批量修改已读标记")
    @ApiOperationSupport(order = 6)
    @PostMapping(value = "/updateReadFlag/batch")
    public ApiResult<Boolean> updateReadFlag(@NotEmpty(message = "记录ID为空") @RequestBody Set<Long> ids) {
        return service.updateViewed(ids, true);
    }

    @PostMapping("/enum/sysMsgSendRecordDelete")
    @ApiOperation(value = "删除发送记录，同时删除明细，物理删除")
    @ApiOperationSupport(order = 6)
    public ApiResult<Boolean> sysMsgSendRecordDelete(@RequestBody SysMsgSendRecordDeleteVO sysMsgSendRecordDeleteVO) {
        return service.sysMsgSendRecordDelete(sysMsgSendRecordDeleteVO);
    }

    @GetMapping("/enum/sysMsgSendState")
    @ApiOperation(value = "发送结果状态枚举查询")
    @ApiOperationSupport(order = 5)
    public ApiResult<List<SysUdcVO>> getSysMsgSendStateEnum() {
        return ApiResult.ok(
                MsgSendStateEnum.getSysUdcVOList()
        );
    }

    @GetMapping("/enum/sysMsgSendTypeEnum")
    @ApiOperation(value = "消息发送渠道类型枚举")
    @ApiOperationSupport(order = 6)
    public ApiResult<List<SysUdcVO>> getSysMsgSendTypeEnum() {
        return ApiResult.ok(
                MsgSendTypeEnum.getSysUdcVOList()
        );
    }


}
