package com.elitescloud.cloudt.system.modules.message.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.system.constant.MsgTypeEnum;
import com.elitescloud.cloudt.system.constant.SysMsgReceiverTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023/5/23 10:08
 */
@Entity
@Table(name = "sys_msg_send_record_dtl", indexes = {
        @Index(name = "index_msg_recorddtl_templateCode", columnList = "templateCode"),
        @Index(name = "index_msg_recorddtl_msgSendRecordId", columnList = "msgSendRecordId"),
        @Index(name = "index_msg_recorddtl_sentTypeCode", columnList = "sentTypeCode"),
        @Index(name = "index_msg_recorddtl_msgType", columnList = "msgType"),
        @Index(name = "index_msg_recorddtl_sendUserId", columnList = "sendUserId"),
        @Index(name = "index_msg_recorddtl_sendusercode", columnList = "sendUserCode"),
        @Index(name = "index_msg_recorddtl_sentTimeStart", columnList = "sentTimeStart"),
        @Index(name = "index_msg_recorddtl_sendState", columnList = "sendState"),
        @Index(name = "index_msg_recorddtl_batchUuid", columnList = "batchUuid"),
        @Index(name = "index_msg_recorddtl_recipentusercode", columnList = "recipientUserCode"),
        @Index(name = "index_msg_recorddtl_recipientUserId", columnList = "recipientUserId"),
})
@Comment("消息发送明细")
@Getter
@Setter
@DynamicInsert
@DynamicUpdate
public class SysMsgSendRecordDtlDO extends BaseModel {
    private static final long serialVersionUID = 4577961474294757163L;

    @Comment("消息发送主表")
    @Column()
    private Long msgSendRecordId;

    /**
     * @see MsgTypeEnum
     */
    @Comment("消息类型-枚举-模板-自定义")
    @Column(length = 20)
    private String msgType;

    /**
     * @see com.elitescloud.cloudt.system.constant.MsgSendStateEnum
     */
    @Comment("发送状态-枚举-发送中，成功，失败")
    @Column(length = 20)
    private String sendState;

    /**
     * @see com.elitescloud.cloudt.system.constant.MsgSendTypeEnum
     */
    @Comment("发送类型-短信-邮箱-站内信-站内提醒websoket")
    @Column(length = 20)
    private String sentTypeCode;

    @Comment("发送类型名称")
    @Column(length = 40)
    private String sendTypeName;

    @Comment("发送时间")
    @Column()
    private LocalDateTime sentTimeStart;

    @Comment("发送回执时间")
    @Column()
    private LocalDateTime sentTimeEnd;

    @Comment("发送回执信息")
    @Column()
    @Lob
    private String sentEndMessage;

    @Comment("发送系统内异常信息")
    @Column()
    @Lob
    private String sentErrMessage;

    @Comment("发送人id")
    @Column(length = 40)
    private String sendUserId;

    @Comment("发送人名称")
    @Column(length = 40)
    private String sendUserName;

    @Comment("接收人名称")
    @Column(length = 200)
    private String recipientUserName;

    @Comment("接收人id")
    @Column(length = 40)
    private String recipientUserId;

    @Comment("发送人编码")
    @Column(length = 40)
    private String sendUserCode;

    @Comment("接收人编码")
    @Column(length = 40)
    private String recipientUserCode;

    @Comment("模板id")
    @Column()
    private Long templateId;

    @Comment("模板编码")
    @Column()
    private String templateCode;

    @Comment("模板名称")
    @Column()
    private String templateName;

    @Comment("主题")
    @Column()
    private String subject;

    @Comment("标题内容")
    @Column()
    private String titleContent;

    @Comment("消息内容")
    @Lob
    private String messageContent;

    @Comment("模板发送参数json")
    @Lob
    private String templateSendParamJson;

    @Comment("外部模板id")
    @Column(length = 200)
    private String externalTemplateId;

    @Comment("接收账号")
    @Column()
    private String recipientAccount;

    /**
     * @see SysMsgReceiverTypeEnum
     */
    @Comment(value = "接收账号类型", defaultValue = "'RECEIVER'")
    @Column()
    private String recipientAccountType;

    @Comment("回执账号ID")
    @Column()
    private String receiptUserId;

    @Comment("回执账号")
    @Column()
    private String receiptAccount;

    @Comment("扩展参数1")
    @Column()
    @Lob
    private String extend1;

    @Comment("扩展参数2")
    @Column()
    @Lob
    private String extend2;

    @Comment("扩展参数3")
    @Column()
    @Lob
    private String extend3;

    @Comment("扩展参数4")
    @Column()
    @Lob
    private String extend4;

    @Comment("扩展参数5")
    @Column()
    @Lob
    private String extend5;

    @Comment("是否已读")
    @Column()
    private Boolean readFlg;

    @Comment("已读时间")
    @Column()
    private String readTime;

    @Comment("批量号")
    @Column()
    private String batchUuid;

    @Comment("自定义json参数")
    @Column()
    @Lob
    private String customParamJson;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SysMsgSendRecordDtlDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SysMsgSendRecordDtlDO entity = (SysMsgSendRecordDtlDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }


}