package com.elitescloud.cloudt.system.modules.message.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.system.common.MsgTemplateReceiverEnum;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 消息模板默认接收人.
 *
 * @author Kaiser（wang shao）
 * @date 2023/12/20
 */
@Entity
@Table(name = "sys_msg_template_receiver", indexes = {
        @Index(name = "idx_msg_tmpl_rer_tmplid", columnList = "templateId")
})
@Comment("消息模板默认接收人")
@Getter
@Setter
public class SysMsgTemplateReceiverDO extends BaseModel {
    private static final long serialVersionUID = -4208232025260397643L;

    @Column()
    @Comment(value = "模板Id")
    private Long templateId;

    @Column()
    @Comment(value = "模板配置ID")
    private Long templateConfigId;

    /**
     * {@link MsgTemplateReceiverEnum}
     */
    @Column(nullable = false)
    @Comment(value = "接收人类型")
    private String receiverType;

    @Column()
    @Comment(value = "接收人ID")
    private Long receiverId;

    @Column()
    @Comment(value = "顺序", defaultValue = "0")
    private Integer sortNo;
}
