package com.elitescloud.cloudt.system.modules.message.repository;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.modules.message.entity.QSysMsgTemplateConfigDO;
import com.elitescloud.cloudt.system.modules.message.entity.SysMsgTemplateConfigDO;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/12/20
 */
@Repository
public class SysMsgTemplateConfigRepoProc extends BaseRepoProc<SysMsgTemplateConfigDO> {
    private static final QSysMsgTemplateConfigDO QDO = QSysMsgTemplateConfigDO.sysMsgTemplateConfigDO;

    public SysMsgTemplateConfigRepoProc() {
        super(QDO);
    }

    /**
     * 根据模板ID查询
     *
     * @param templateId
     * @return
     */
    public List<SysMsgTemplateConfigDO> listByTemplateId(long templateId) {
        return super.getListByValue(QDO.templateId, templateId);
    }

    /**
     * 根据模板编码查询
     *
     * @param templateCode
     * @return
     */
    public List<SysMsgTemplateConfigDO> listByTemplateCode(String templateCode) {
        return super.getListByValue(QDO.templateCode, templateCode);
    }

    /**
     * 根据模板ID获取ID
     *
     * @param templateId
     * @param enabled
     * @return
     */
    public Map<String, Long> getIdsByTemplateId(long templateId, Boolean enabled) {
        var predicate = PredicateBuilder.builder()
                .andEq(QDO.templateId, templateId)
                .andEq(QDO.sendTypeSwitch, enabled)
                .build();

        return super.jpaQueryFactory.select(QDO.id, QDO.sendTypeCode)
                .from(QDO)
                .where(predicate)
                .fetch()
                .stream()
                .filter(t -> StringUtils.hasText(t.get(QDO.sendTypeCode)))
                .collect(Collectors.toMap(t -> t.get(QDO.sendTypeCode), t -> t.get(QDO.id), (t1, t2) -> t1));
    }
}
