package com.elitescloud.cloudt.system.modules.message.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.req.SysSiteMsgSaveDTO;
import com.elitescloud.cloudt.system.dto.resp.msg.SysSiteMsgViewedDTO;
import com.elitescloud.cloudt.system.modules.message.service.SiteMsgMngService;
import com.elitescloud.cloudt.system.modules.message.service.SiteMsgQueryService;
import com.elitescloud.cloudt.system.provider.msg.SiteMsgRpcService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/11/29
 */
@RestController
@RequestMapping(value = SiteMsgRpcService.URI, produces = MediaType.APPLICATION_JSON_VALUE)
public class SiteMsgRpcServiceImpl implements SiteMsgRpcService {

    @Autowired
    private SiteMsgMngService mngService;
    @Autowired
    private SiteMsgQueryService queryService;

    @Override
    public ApiResult<String> send(SysSiteMsgSaveDTO saveDTO) {
        return mngService.send(saveDTO);
    }

    @Override
    public ApiResult<String> delete(String batchId) {
        return mngService.delete(batchId);
    }

    @Override
    public ApiResult<List<SysSiteMsgViewedDTO>> queryViewedResult(String batchId) {
        return queryService.queryViewedResult(batchId);
    }
}
