package com.elitescloud.cloudt.system.modules.orgtree.controller;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.resp.OrgTreeNodeRespVO;
import com.elitescloud.cloudt.system.modules.orgtree.service.MultiOrgTreeQueryService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 通用多组织树接口.
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/7
 */
@Api(tags = "通用多组织树接口")
@RestController()
@RequestMapping(value = "/common/multiOrgTree/")
public class CommonMultiOrgTreeController {

    private MultiOrgTreeQueryService queryService;

    @ApiOperation(value = "[通用组件]查询多组织树列表")
    @GetMapping(value = "/trees")
    public ApiResult<List<IdCodeNameParam>> listOrgTree() {
        return queryService.listOrgTree();
    }

    @ApiOperation(value = "[通用组件]查询组织树信息")
    @ApiOperationSupport(order = 2)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "treeId", value = "树的ID", required = true),
            @ApiImplicitParam(name = "tree", value = "是否返回树形结构数据", dataType = "boolean", defaultValue = "true"),
            @ApiImplicitParam(name = "employee", value = "是否返回员工数据", dataType = "boolean", defaultValue = "false"),
            @ApiImplicitParam(name = "all", value = "包含所有组织数据", dataType = "boolean", defaultValue = "true"),
    })
    @GetMapping(value = "/tree/get")
    public ApiResult<List<OrgTreeNodeRespVO>> getTree(@RequestParam(name = "treeId") Long treeId,
                                                      @RequestParam(name = "tree", defaultValue = "true") Boolean tree,
                                                      @RequestParam(name = "employee", defaultValue = "false") Boolean employee,
                                                      @RequestParam(name = "all", defaultValue = "true") Boolean all) {
        return queryService.getTree(treeId, tree, employee, all);
    }

    @Autowired
    public void setQueryService(MultiOrgTreeQueryService queryService) {
        this.queryService = queryService;
    }
}
