package com.elitescloud.cloudt.system.modules.orgtree.convert;

import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import com.elitescloud.cloudt.system.modules.orgtree.model.OrgBuTreeDDTO;
import com.elitescloud.cloudt.system.modules.orgtree.model.OrgBuTreeDDetailDTO;
import com.elitescloud.cloudt.system.modules.orgtree.model.OrgBuTreedAllDTO;
import com.elitescloud.cloudt.system.modules.orgtree.model.entity.OrgBuTreeDDO;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.OrgBuTreeDSaveParam;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.OrgBuTreeVDSaveParam;
import com.elitescloud.cloudt.system.modules.orgtree.model.vo.OrgBuTreeDRemoteVO;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2021/3/15
 */
@Mapper(config = BaseMapperConfig.class)
public interface OrgBuTreeDConvert {

    OrgBuTreeDConvert INSTANCE = Mappers.getMapper(OrgBuTreeDConvert.class);

    /**
     * saveParam转DO
     * @param param
     * @return
     */
    OrgBuTreeDDO saveParamToDo(OrgBuTreeDSaveParam param);

    /**
     * DO转dto
     * @param orgBuTreeDDO
     * @return
     */
    OrgBuTreeDDetailDTO doToDto(OrgBuTreeDDO orgBuTreeDDO);

    /**
     * DO转dto
     * @param orgBuTreeDDO
     * @return
     */
    List<OrgBuTreeDDetailDTO> doToDto(List<OrgBuTreeDDO> orgBuTreeDDO);

    /**
     * DO转OrgBuTreedAllDTO
     * @param orgBuTreeDDO
     * @return
     */
    OrgBuTreedAllDTO doToAllDto(OrgBuTreeDDO orgBuTreeDDO);

    /**
     * List<OrgBuTreeDDTO>转List<OrgBuTreeDRemoteVO>
     * @param orgBuTreeDVOList
     * @return
     */
    List<OrgBuTreeDRemoteVO> dtoToRemoteVo(List<OrgBuTreeDDTO> orgBuTreeDVOList);

    /**
     *  saveList to doList
     * @param params
     * @return
     */
    List<OrgBuTreeDDO> saveListToDoList(List<OrgBuTreeVDSaveParam> params);

    List<OrgBuTreeDDTO> doToTreeDto(List<OrgBuTreeDDO> orgBuTreeDDOS);
}
