package com.elitescloud.cloudt.system.modules.orgtree.model;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author : Scott.zhang(zhang hang)
 * @Date : 2022/1/1114:43
 */
@Data
public class OrgBuTreeDTO implements Serializable {
    private static final long serialVersionUID = -8495687191684334889L;
    /**
     * ID
     */
    @ApiModelProperty(value = "ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * 组织树类型
     */
    @ApiModelProperty(value = "组织树类型")
    @SysCode(sys = "yst-supp", mod = "BUTREE_TYPE")
    private String buTreeType;
    private String buTreeTypeName;

    /**
     * 组织树编号
     */
    @ApiModelProperty(value = "组织树编号")
    private String buTreeCode;

    /**
     * 组织树名称
     */
    @ApiModelProperty(value = "组织树名称")
    private String buTreeName;

    /**
     * 组织树状态
     */
    @ApiModelProperty(value = "组织树状态")
    @SysCode(sys = "yst-supp", mod = "BUTREE_STATUS")
    private String buTreeStatus;
    private String buTreeStatusName;

    /**
     * 组织树当前版本
     */
    @ApiModelProperty(value = "组织树版本")
    private String nowVersion;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createTime;

    /**
     * 记录创建者
     */
    @ApiModelProperty(value = "记录创建者")
    private String creator;
    /**
     * 发布时间
     */
    @ApiModelProperty(value = "发布时间")
    @Column
    private LocalDateTime releaseTime;

    /**
     * 是否当前版本
     */
    @ApiModelProperty(value = "是否当前版本")
    private Boolean isNowVersion;

    /**
     * 停用时间
     */
    @ApiModelProperty(value = "停用时间")
    private LocalDateTime disableTime;

    /**
     * 发布人
     */
    @ApiModelProperty(value = "发布人")
    private String releaseUser;

    /**
     * 版本说明
     */
    @ApiModelProperty(value = "版本说明")
    private String versionInstruction;
}
