package com.elitescloud.cloudt.system.modules.orgtree.model.entity;

import com.elitescloud.cloudt.system.modules.orgtree.model.TreeModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2020/7/2
 */
@Entity(name = "OrgBuTreeDDO_system")
@Table(name = "sys_org_bu_tree_d", indexes = {
        @Index(name = "idx_bu_tree_pid", columnList = "pid"),
        @Index(name = "idx_bu_tree_code_path", columnList = "codePath")
})
@org.hibernate.annotations.Table(appliesTo = "sys_org_bu_tree_d", comment = "组织树明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "组织树明细", description = "组织树明细")
public class OrgBuTreeDDO extends TreeModel implements Serializable,Cloneable {

    private static final long serialVersionUID = 1L;

    /**
     * 组织树ID
     */
    @ApiModelProperty(value = "组织树ID")
    @Column(nullable = false)
    private Long buTreeId;

    /**
     * 组织ID
     */
    @ApiModelProperty(value = "组织ID")
    @Column()
    private Long buId;

    /**
     * 组织编号
     */
    @ApiModelProperty(value = "组织编号")
    @Column()
    private String buCode;


    /**
     * 数据来源
     */
    @ApiModelProperty(value = "类别码20")
    @Column()
    private String dataSource;

    /**
     * 同步状态
     */
    @ApiModelProperty(value = "同步的数据是否需要覆盖")
    @Column()
    private Boolean syncStatus = false;

    @Override
    public OrgBuTreeDDO clone() throws CloneNotSupportedException {
        return (OrgBuTreeDDO) super.clone();
    }

}
