package com.elitescloud.cloudt.system.modules.orgtree.model.vo;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2021/8/3
 */
@Data
@ApiModel(description = "组织树分页反参(前端组件)")
public class OrgBuTreeComPagingVO implements Serializable {
    private static final long serialVersionUID = -2489110707345414878L;

    /**
     * ID
     */
    @ApiModelProperty(value = "ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * 组织树类型
     */
    @ApiModelProperty(value = "组织树类型")
    @SysCode(sys = "yst-supp", mod = "BUTREE_TYPE")
    private String buTreeType;
    private String buTreeTypeName;

    /**
     * 组织树编号
     */
    @ApiModelProperty(value = "组织树编号")
    private String buTreeCode;

    /**
     * 组织树名称
     */
    @ApiModelProperty(value = "组织树名称")
    private String buTreeName;

    /**
     * 组织树状态
     */
    @ApiModelProperty(value = "组织树状态")
    @SysCode(sys = "yst-supp", mod = "BUTREE_STATUS")
    private String buTreeStatus;
    private String buTreeStatusName;

    /**
     * 组织树当前版本
     */
    @ApiModelProperty(value = "组织树当前版本")
    private String nowVersion;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createTime;

    /**
     * 记录创建者
     */
    @ApiModelProperty(value = "记录创建者")
    private String creator;
}
