package com.elitescloud.cloudt.system.modules.orgtree.model.vo;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.cloudt.system.modules.orgtree.model.RemoteTreeNode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2021/3/16
 */
@Data
@ApiModel(description = "组织树明细反参")
public class OrgBuTreeDRemoteVO implements RemoteTreeNode<OrgBuTreeDRemoteVO> {

    private static final long serialVersionUID = -2430881546380008411L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "组织ID")
    private Long id;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "组织树ID")
    private Long buTreeId;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "BU组织名称")
    private Long buId;

    /**
     * BU组织编号
     */
    @ApiModelProperty("BU组织编号")
    private String buCode;

    /**
     * BU组织名称
     */
    @ApiModelProperty("BU组织名称")
    private String buName;

    /**
     * BU组织简称
     */
    @ApiModelProperty("BU组织简称")
    private String buAbbr;

    /**
     * 组织类型 [UDC]ORG:BU_TYPE
     */
    @ApiModelProperty("组织类型 [UDC]ORG:BU_TYPE")
    @SysCode(sys = "yst-supp", mod = "BU_TYPE")
    private String buType;
    private String buTypeName;

    /**
     * 组织状态 [UDC]ORG:BU_STATUS
     */
    @ApiModelProperty("组织状态 [UDC]ORG:BU_STATUS")
    @SysCode(sys = "yst-supp", mod = "BU_STATUS")
    private String buStatus;
    private String buStatusName;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "上级ID")
    private Long pid;

    /**
     * 级别
     */
    @ApiModelProperty("级别")
    private Integer level;

    /**
     * 排序序号
     */
    @ApiModelProperty("排序序号")
    private Integer sortNo;

    /**
     * 树形结构中，是否是末尾节点
     */
    @ApiModelProperty(value = "是否末尾节点")
    private Boolean isLeaf;

    /**
     * 商品品类下级
     */
    @ApiModelProperty("商品品类下级")
    private List<OrgBuTreeDRemoteVO> treeNodes;
}
