package com.elitescloud.cloudt.system.modules.warning.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.modules.warning.web.model.vo.query.SysWarningRecordDetailPageQueryVO;
import com.elitescloud.cloudt.system.modules.warning.web.model.vo.query.SysWarningRecordPageQueryVO;
import com.elitescloud.cloudt.system.modules.warning.web.model.vo.resp.SysWarningRecordDetailRespVO;
import com.elitescloud.cloudt.system.modules.warning.web.model.vo.resp.SysWarningRecordPageRespVO;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/9/3 周三
 */
public interface SysWarningRecordMngService {

    /**
     * 分页查询
     *
     * @param queryVO 查询参数
     * @return PagingVO<SysWarningRecordPageRespVO>
     */
    ApiResult<PagingVO<SysWarningRecordPageRespVO>> pageQuery(SysWarningRecordPageQueryVO queryVO);

    /**
     * 获取执行记录明细
     *
     * @param queryVO 执行记录ID
     * @return SysWarningRecordDetailRespVO
     */
    ApiResult<PagingVO<SysWarningRecordDetailRespVO>> getDetail(SysWarningRecordDetailPageQueryVO queryVO);

    /**
     * 重新推送
     *
     * @param recordDetailId 执行记录明细ID
     * @return Boolean
     */
    ApiResult<Boolean> rePush(Long recordDetailId);
}
