package com.elitescloud.cloudt.system.modules.warning.service.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.system.modules.warning.common.SysWarningOprEnum;
import com.elitescloud.cloudt.system.modules.warning.common.SysWarningRelEnum;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.io.Serial;

/**
 * 预警规则的场景条件.
 *
 * @author Kaiser（wang shao）
 * @date 2025/8/4 周一
 */
@Entity
@Table(name = "sys_warning_scene_cond", indexes = {
        @Index(name = "idx_warning_scene_cond_code", columnList = "ruleCode"),
})
@Comment("预警规则的场景条件")
@Getter
@Setter
public class SysWarningSceneCondDO extends BaseModel {
    @Serial
    private static final long serialVersionUID = -7499443580912654939L;

    @Comment(value = "规则编码")
    @Column(nullable = false)
    private String ruleCode;

    @Comment(value = "条件项, [UDC]WARNING_CONDITION")
    @Column(nullable = false)
    private String condTerm;

    /**
     * @see SysWarningOprEnum
     */
    @Comment(value = "条件值")
    @Column(nullable = false)
    private String oprValue;

    @Comment(value = "数据范围")
    @Column()
    @Lob
    private String valueListJson;

    /**
     * @see SysWarningRelEnum
     */
    @Comment(value = "条件值")
    @Column()
    private String relValue;

    @Comment(value = "排序号", defaultValue = "0")
    @Column()
    private Integer sortNo;
}
