package com.elitescloud.cloudt.system.modules.warning.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.modules.warning.service.model.entity.QSysWarningRecordDetailDO;
import com.elitescloud.cloudt.system.modules.warning.service.model.entity.QSysWarningRecordNoticeDO;
import com.elitescloud.cloudt.system.modules.warning.service.model.entity.SysWarningRecordDetailDO;
import com.elitescloud.cloudt.system.modules.warning.web.model.vo.query.SysWarningRecordDetailPageQueryVO;
import org.springframework.stereotype.Repository;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/9/3 周三
 */
@Repository()
public class SysWarningRecordDetailRepoProc extends BaseRepoProc<SysWarningRecordDetailDO> {
    private static final QSysWarningRecordDetailDO QDO = QSysWarningRecordDetailDO.sysWarningRecordDetailDO;
    private static final QSysWarningRecordNoticeDO QDO_NOTICe = QSysWarningRecordNoticeDO.sysWarningRecordNoticeDO;

    public SysWarningRecordDetailRepoProc() {
        super(QDO);
    }

    public PagingVO<SysWarningRecordDetailDO> pageQuery(SysWarningRecordDetailPageQueryVO queryVO) {
        var predicate = PredicateBuilder.builder()
                .and(QDO.masId.eq(queryVO.getMasId()))
                .andLike(QDO.docCode, queryVO.getDocCode())
                .andLike(QDO.docName, queryVO.getDocName())
                .andEq(QDO.verifyPass, queryVO.getSuccess())
                .build();
        return super.queryByPage(predicate, queryVO.getPageRequest(), QDO.docCode.asc());
    }
}
