package com.elitescloud.cloudt.system.modules.warning.service.repo;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.modules.warning.service.model.entity.QSysWarningRuleDO;
import com.elitescloud.cloudt.system.modules.warning.service.model.entity.SysWarningRuleDO;
import com.elitescloud.cloudt.system.modules.warning.web.model.vo.query.SysWarningRulePageQueryVO;
import com.elitescloud.cloudt.system.modules.warning.web.model.vo.resp.SysWarningRulePageRespVO;
import com.querydsl.core.types.Projections;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.Collection;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/8/4 周一
 */
@Repository
public class SysWarningRuleRepoProc extends BaseRepoProc<SysWarningRuleDO> {
    private static final QSysWarningRuleDO QDO = QSysWarningRuleDO.sysWarningRuleDO;

    public SysWarningRuleRepoProc() {
        super(QDO);
    }

    /**
     * 更新启用状态
     *
     * @param ids
     * @param enabled
     */
    public void updateEnabled(@NotEmpty Collection<Long> ids, boolean enabled) {
        jpaQueryFactory.update(QDO)
                .set(QDO.enabled, enabled)
                .where(QDO.id.in(ids))
                .execute();
    }

    /**
     * 判断编码是否已存在
     *
     * @param ruleCode
     * @return
     */
    public boolean existsRuleCode(@NotBlank String ruleCode) {
       return super.exists(QDO.ruleCode, ruleCode);
    }

    /**
     * 分页查询
     *
     * @param queryVO
     * @return
     */
    public PagingVO<SysWarningRulePageRespVO> pageMng(SysWarningRulePageQueryVO queryVO) {
        var qBean = Projections.bean(SysWarningRulePageRespVO.class, QDO.id, QDO.ruleCode, QDO.ruleName, QDO.scene,
                QDO.execTimeType, QDO.execTimeValues, QDO.execStartTime, QDO.noticeRateValue, QDO.sendTypes, QDO.enabled,
                QDO.creator, QDO.createTime, QDO.modifyTime);
        var predicate = PredicateBuilder.builder()
                .andEq(QDO.scene, queryVO.getScene())
                .andLike(QDO.ruleName, queryVO.getRuleName())
                .andEq(QDO.enabled, queryVO.getEnabled())
                .build();
        return super.queryByPage(qBean, predicate, queryVO.getPageRequest(), QDO.createTime.desc());
    }

    public List<IdCodeNameParam> listIdCodeNames(@NotEmpty Collection<String> ruleCodes) {
        var qBean = Projections.bean(IdCodeNameParam.class, QDO.id, QDO.ruleCode.as("code"), QDO.ruleName.as("name"));
        return super.getList(qBean, QDO.ruleCode.in(ruleCodes));
    }
}
