package com.elitescloud.cloudt.system.modules.wecom.model;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 基本结果.
 *
 * @author Kaiser（wang shao）
 * @date 2024/8/16
 */
@Getter
@Setter
public abstract class BaseResult implements Serializable {
    private static final long serialVersionUID = -4372036722420535276L;

    /**
     * 错误码
     * <p>
     * 0（或空）为成功，非0为失败
     */
    private Integer errcode;

    /**
     * 错误提示语
     */
    private String errmsg;

    /**
     * 是否成功
     *
     * @return 是否成功
     */
    public boolean isSuccess() {
        return errcode == null || errcode == 0;
    }
}
