package com.elitescloud.cloudt.system.modules.wecom.model.msg;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 小程序通知消息.
 * <p>
 * <a href="https://developer.work.weixin.qq.com/document/path/90236#markdown%E6%B6%88%E6%81%AF">API文档</a>
 *
 * @author Kaiser（wang shao）
 * @date 2025/6/5 周四
 */
@Getter
@Setter
public class MiniProgramNoticeMsg extends BaseMsg {
    private static final long serialVersionUID = 3729535329901857357L;

    /**
     * 消息类型
     */
    private final String msgtype = "miniprogram_notice";

    /**
     * 消息体
     */
    private MiniProgramNotice miniprogram_notice;

    @Override
    public String getMsgtype() {
        return msgtype;
    }

    @Getter
    @Setter
    public static class MiniProgramNotice implements Serializable {
        private static final long serialVersionUID = 925072186758910821L;

        /**
         * 小程序appid
         * <p>
         * 必须是与当前应用关联的小程序
         */
        private String appid;

        /**
         * 小程序页面
         * <p>
         * 点击消息卡片后的小程序页面，最长1024个字节，仅限本小程序内的页面。该字段不填则消息点击后不跳转。
         */
        private String page;

        /**
         * 消息标题
         * <p>
         * 长度限制4-12个汉字（支持id转译）
         */
        private String title;

        /**
         * 消息描述
         * <p>
         * 长度限制4-12个汉字（支持id转译）
         */
        private String description;

        /**
         * 是否放大第一个content_item
         */
        private Boolean emphasis_first_item;

        /**
         * 消息内容键值对
         * <p>
         * 最多允许10个item
         */
        private List<ContentItem> content_item;
    }

    @Getter
    @Setter
    public static class ContentItem implements Serializable {
        private static final long serialVersionUID = -8390560948641667726L;

        /**
         * 名称
         * <p>
         * 长度10个汉字以内
         */
        private String key;

        /**
         * 值
         * <p>
         * 长度30个汉字以内（支持id转译）
         * key和value两个字段同时为空时，该键值对将被忽略
         */
        private String value;

        public ContentItem() {
        }

        public ContentItem(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}
