package com.elitescloud.cloudt.system.modules.wecom.model.user;

import com.elitescloud.cloudt.system.modules.wecom.model.user.attr.ExtAttr;
import com.elitescloud.cloudt.system.modules.wecom.model.user.attr.ExternalProfile;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 成员保存信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/8/21
 */
@Getter
@Setter
public class UserSaveParam implements Serializable {
    private static final long serialVersionUID = 1706978732919905010L;

    /**
     * 成员ID
     *
     */
    private String userid;

    /**
     * 成员名称
     */
    private String name;

    /**
     * 成员别名
     */
    private String alias;

    /**
     * 手机号
     * <p>
     * 企业内必须唯一，与email不能同时为空。若成员已激活企业微信，则需成员自行修改（此情况下该参数被忽略，但不会报错）
     */
    private String mobile;

    /**
     * 所属部门ID
     */
    private List<Long> department;

    /**
     * 部门内的排序值
     * <p>
     * 默认为0，成员次序以创建时间从小到大排列。个数必须和参数department的个数一致，数值越大排序越前面。
     */
    private List<Integer> order;

    /**
     * 职务
     */
    private String position;

    /**
     * 性别
     * <p>
     * 1表示男性，2表示女性
     */
    private Integer gender;

    /**
     * 邮箱
     * <p>
     * 企业内必须唯一，mobile/email二者不能同时为空
     */
    private String email;

    /**
     * 企业微信邮箱
     */
    private String biz_mail;

    /**
     * 座机
     */
    private String telephone;

    /**
     * 是否为部门负责人
     * <p>
     * 1是，0否，个数与department一致
     */
    private List<Integer> is_leader_in_dept;

    /**
     * 直属上级userId
     */
    private List<Long> direct_leader;

    /**
     * 成员头像的mediaid
     * <p>
     * 通过素材管理接口上传的mediaid
     */
    private String avatar_mediaid;

    /**
     * 启用或禁用
     * <p>
     * 1表示启用成员，0表示禁用成员
     */
    private Integer enable;

    /**
     * 扩展属性
     */
    private ExtAttr extattr;

    /**
     * 是否邀请该成员使用企业微信
     */
    private Boolean to_invite;

    /**
     * 成员对外属性
     */
    private ExternalProfile external_profile;

    /**
     * 对外职务
     * <p>
     * 默认使用position
     */
    private String external_position;

    /**
     * 视频号名字
     * <p>
     * 须从企业绑定到企业微信的视频号中选择，可在“我的企业”页中查看绑定的视频号
     */
    private String nickname;

    /**
     * 地址
     */
    private String address;

    /**
     * 主部门
     */
    private Long main_department;
}
