package com.elitescloud.cloudt.system.modules.wecom.model.user.attr;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 文本属性.
 *
 * @author Kaiser（wang shao）
 * @date 2024/8/21
 */
@Getter
@Setter
public class TextAttr extends BaseAttr {
    private static final long serialVersionUID = -8014416116735520768L;

    /**
     * 内容
     */
    private Text text;

    /**
     * 创建文本
     *
     * @param name
     * @param txt
     * @return
     */
    public static TextAttr create(String name, String txt) {
        Text text1 = new Text();
        text1.setValue(txt);

        TextAttr attr = new TextAttr();
        attr.setText(text1);
        attr.setType(0);
        attr.setName(name);
        return attr;
    }

    @Getter
    @Setter
    public static class Text implements Serializable {
        private static final long serialVersionUID = -2693009986337301224L;

        /**
         * 文本内容
         */
        private String value;
    }
}
