package com.elitescloud.cloudt.system.provider.job.scheduler;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.stereotype.Component;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/26
 */
@Component
public class BaseSchedulerConfigurer implements SchedulingConfigurer {
    private static final Logger logger = LoggerFactory.getLogger(BaseSchedulerConfigurer.class);

    @Autowired
    private ClearExpiredResourcesTask clearExpiredResourcesTask;
    @Autowired
    private ClearExpiredMqMessageTask clearExpiredMqMessageTask;
    @Autowired
    private ClearExpiredSysThirdApiLogTask clearExpiredSysThirdApiLogTask;

    @Override
    public void configureTasks(@NonNull ScheduledTaskRegistrar taskRegistrar) {
        taskRegistrar.addFixedRateTask(() -> {
            try {
                CompletableFuture.runAsync(() -> clearExpiredResourcesTask.run());
            } catch (Exception e) {
                logger.info("删除过期文件异常", e);
            }
        }, Duration.ofDays(2).toMillis());

        taskRegistrar.addFixedRateTask(() -> {
            try {
                CompletableFuture.runAsync(() -> clearExpiredMqMessageTask.run());
            } catch (Exception e) {
                logger.info("删除过期MQ消息异常", e);
            }
        }, Duration.ofDays(1).toMillis());

        taskRegistrar.addCronTask(() -> {
            try {
                CompletableFuture.runAsync(() -> clearExpiredSysThirdApiLogTask.run());
            } catch (Exception e) {
                logger.info("删除过期外部接口日志异常", e);
            }
        }, "0 0 1 * * ?");
    }
}
